#include <bits/stdc++.h>

using namespace std;

struct query {
	int x;
	int cnt;
	int index;
};

struct query2 {
	int x;
	int level;
	bool positive;
};

struct Fenwick {
	int n;
	vector<int> fenw;
	Fenwick(int _n) {
		n = _n;
		fenw.resize(n);
		for(int i = 0; i < n; i++) fenw[i] = 0;
	}
	void update(int x, int val) { for(int i = x; i < n; i += (i & -i)) fenw[i] += val; }
	int get(int r) {
		int ans = 0;
		for(int i = r; i >= 1; i -= (i & -i)) ans += fenw[i];
		return ans;
	}
	int get(int l, int r) { return get(r) - get(l - 1); }
};

const int N = (1 << 20) + 10, Q = 5e5 + 10, LOG = 21;
int n, q;
int lg;
int a[N];
query queries[Q];
vector<query2> qs[N];
int start[N][LOG];
int cnt[N][LOG];
bool added[N];

void build(int l, int r, int level) {
	for(int i = l; i <= r; i++) start[i][level] = l;
	if(l == r) return;
	int mid = (l + r) / 2;
	build(l, mid, level - 1);
	build(mid + 1, r, level - 1);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cin >> n;
    lg = __builtin_ctz(n);
    build(1, n, lg);
    for(int i = 1; i <= n; i++) cin >> a[i];
    cin >> q;
    for(int i = 0; i < q; i++) {
    	cin >> queries[i].x >> queries[i].cnt;
    	queries[i].index = i;
    	if(!added[queries[i].x]) {
    		for(int level = 1; level <= lg; level++) {
				qs[start[queries[i].x][level] - 1].push_back({queries[i].x, level, false});
				qs[start[queries[i].x][level] + (1 << level) - 1].push_back({queries[i].x, level, true});
			}
    	}
    	added[queries[i].x] = true;
    }
    Fenwick fw(n + 1);
    for(int i = 1; i <= n; i++) {
    	fw.update(a[i], 1);
    	for(query2 Q : qs[i]) {
    		if(Q.positive) cnt[Q.x][Q.level] += fw.get(a[Q.x] - 1);
    		else cnt[Q.x][Q.level] -= fw.get(a[Q.x] - 1);
    	}
    }
    for(int i = 0; i < q; i++) {
    	query Q = queries[i];
		bool found = false;
		for(int level = 1; level <= lg; level++) {
			int L = start[Q.x][level];
			int R = L + (1 << level) - 1;
			int len = R - L + 1;
			int need = len - 1 - cnt[Q.x][level];
			int have = a[Q.x] - 1 - cnt[Q.x][level];
			if(need > min(have, Q.cnt)) {
				cout << level << "\n";
				found = true;
				break;
			}
		}
		if(!found) cout << lg + 1 << "\n";
    }
    return 0;
}